<?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <tr>
        <td><?php echo e($loop->iteration); ?></td>
        <td><?php echo e(formatted_date($employee->join_date)); ?></td>
        <td><?php echo e($employee->name); ?></td>
        <td><?php echo e($employee->phone); ?></td>
        <td><?php echo e(optional($employee->designation)->name); ?></td>
        <td class="fw-bold text-dark"><?php echo e(currency_format($employee->salary)); ?></td>
        <td>
            <div class="badge <?php echo e($employee->status == 1 ? 'bg-success' : 'bg-danger'); ?>"><?php echo e($employee->status == 1 ? 'Active' : 'Deactive'); ?></div>
        </td>
        <td class="print-d-none">
            <div class="dropdown table-action">
                <button type="button" data-bs-toggle="dropdown">
                    <i class="far fa-ellipsis-v"></i>
                </button>
                <ul class="dropdown-menu">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('employees-update')): ?>
                    <li>
                        <a href="<?php echo e(route('employees.edit', $employee->id)); ?>" class="edit-btn">
                            <i class="fal fa-pencil-alt"></i>
                            <?php echo e(__('Edit')); ?>

                        </a>
                    </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('employees-delete')): ?>
                    <li>
                        <a href="<?php echo e(route('employees.destroy', $employee->id)); ?>" class="confirm-action" data-method="DELETE">
                            <i class="fal fa-trash-alt"></i>
                            <?php echo e(__('Delete')); ?>

                        </a>
                    </li>
                    <?php endif; ?>
                </ul>
            </div>
        </td>
    </tr>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php /**PATH /home/uliubxaw/wireprod/resources/views/pages/employees/datas.blade.php ENDPATH**/ ?>