<?php $__currentLoopData = $incomes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $income): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <tr>
        <td><?php echo e($loop->iteration); ?></td>
        <td><?php echo e(formatted_date($income->created_at)); ?></td>
        <td><?php echo e($income->party->name ?? ''); ?></td>
        <td><?php echo e($income->party->type ?? ''); ?></td>
        <td><?php echo e($income->category_name); ?></td>
        <td><b><?php echo e(currency_format($income->total_bill)); ?></b></td>
        <td><b><?php echo e(currency_format($income->total_paid)); ?></b></td>
        <td><b><?php echo e(currency_format($income->total_due)); ?></b></td>
        <td>
            <div class="badge bg-<?php echo e($income->status == 1 ? 'primary' : 'danger'); ?>">
                <?php echo e($income->status == 1 ? 'Active' : 'Inactive'); ?>

            </div>
        </td>
        <td class="print-d-none">
            <div class="dropdown table-action">
                <button type="button" data-bs-toggle="dropdown">
                    <i class="far fa-ellipsis-v"></i>
                </button>
                <ul class="dropdown-menu">
                    <li>
                        <a href="<?php echo e(route('partial-payment.voucher', ['income_id' => $income->id])); ?>" target="_blank"><i class="fas fa-print"></i>
                            <?php echo e(__('Partial Payment')); ?>

                        </a>
                    </li>
                </ul>
            </div>
        </td>
    </tr>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php /**PATH /home/uliubxaw/wireprod/resources/views/pages/report/due-collections/datas.blade.php ENDPATH**/ ?>