

<?php $__env->startSection('title'); ?>
    <?php echo e(__('User Profile')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('main_content'); ?>
<div class="erp-state-overview-section">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-4">
                <div class="erp-dashboard-profile card">
                    <div class="profile-bg">
                        <img src="<?php echo e(asset('assets/images/profile/cover-photo.jpg')); ?>" alt="profile-bg">
                    </div>
                    <div class="profile-img">
                        <img id="profile_picture" src="<?php echo e(asset(Auth::user()->image ?? 'assets/images/profile/profile-img.png')); ?>" alt="user avatar">
                    </div>
                    <div class="profile-details card-body">
                        <ul class="list-group">
                            <li class="list-group-item"><span>Name: </span><?php echo e(ucwords($user->name)); ?></li>
                            <li class="list-group-item"><span>Email: </span><?php echo e($user->email); ?></li>
                            <li class="list-group-item"><span>Registration Date:</span> <?php echo e(formatted_date($user->created_at)); ?></li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="col-lg-8">
                <div class="erp-dashboard-profile-section card">
                    <div class="table-header">
                        <h4><?php echo e(__('User Profile')); ?></h4>
                    </div>
                    <form action="<?php echo e(route('user-profile.update',$user->id)); ?>" method="post" enctype="multipart/form-data" class="ajaxform">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('put'); ?>
                        <div class="row">
                            <div class="col-lg-4 mt-3">
                                <label><?php echo e(__('Name')); ?></label>
                            </div>
                            <div class="col-lg-8 mt-3">
                                <input type="text" name="name" value="<?php echo e($user->name); ?>" required class="form-control" placeholder="Enter Your Name">
                            </div>
                            <div class="col-lg-4 mt-3">
                                <label><?php echo e(__('Email')); ?></label>
                            </div>
                            <div class="col-lg-8 mt-3">
                                <input type="email" name="email" value="<?php echo e($user->email); ?>" required class="form-control" placeholder="Enter Your Email">
                            </div>
                            <div class="col-lg-4 mt-3">
                                <label><?php echo e(__('Profile Picture')); ?></label>
                            </div>
                            <div class="col-lg-8 mt-3">
                            <input type="file" name="image" id="upload" class="form-control file-input-change" data-id="profile_picture" accept="image/*">
                            </div>
                            <div class="col-lg-4 mt-3">
                                <label><?php echo e(__('Current Password')); ?></label>
                            </div>
                            <div class="col-lg-8 mt-3">
                                <input type="password" name="current_password" class="form-control" placeholder="Enter Your Current Password">
                            </div>
                            <div class="col-lg-4 mt-3">
                                <label><?php echo e(__('New Password')); ?></label>
                            </div>
                            <div class="col-lg-8 mt-3">
                                <input type="password" name="password" class="form-control" placeholder="Enter New Password">
                            </div>
                            <div class="col-lg-4 mt-3">
                                <label><?php echo e(__('Confirm password')); ?></label>
                            </div>
                            <div class="col-lg-8 mt-3">
                                <input type="password" name="password_confirmation" class="form-control" placeholder="Enter Confirm password">
                            </div>
                            <div class="col-lg-12 mt-5">
                                <button type="submit" class="theme-btn submit-btn"><?php echo e(__('Save Changes')); ?></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/uliubxaw/wireprod/resources/views/pages/profile/index.blade.php ENDPATH**/ ?>