

<?php $__env->startSection('title'); ?>
    <?php echo e(__('Invoice')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('main_content'); ?>
    <div class="section-container print-wrapper p-0 erp-new-invice">
        <div class="erp-table-section">
            <div class="container p-0">
                <button class="print-window theme-btn print-btn float-end"><i class="fa fa-print"></i> Print</button>
                <?php echo $__env->make('pages.invoice.header',['title' => __('Payment Receipt')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <div class="d-flex justify-content-between">
                    <div>
                        <p><strong><?php echo e(__('Party Name')); ?>:</strong> <?php echo e(ucwords($voucher->party->name ?? '')); ?></p>
                        <p><strong><?php echo e(__('Address')); ?>:</strong> <?php echo e($voucher->party->address ?? ''); ?></p>
                        <p><strong><?php echo e(__('Mobile')); ?>:</strong> <?php echo e($voucher->user->phone ?? ''); ?></p>
                        <p><strong><?php echo e(__('Remarks')); ?>:</strong> <?php echo e($voucher->remarks); ?></p>
                    </div>
                    <div>
                        <p><strong><?php echo e(__('Received By')); ?>:</strong> <?php echo e(ucwords($voucher->user->name ?? '')); ?></p>
                        <p><strong><?php echo e(__('Payment Method')); ?>:</strong> <?php echo e(ucfirst($voucher->payment_method == 'party_balance' ? 'Wallet' : $voucher->payment_method)); ?></p>
                        <p><strong><?php echo e(__('Payment Date')); ?>:</strong> <?php echo e(formatted_date($voucher->created_at, 'd M, Y h:i:s A')); ?></p>
                    </div>
                </div>
                <table class="table commercial-invoice text-start table-bordered text-center invoice-two border-0 mt-2" id="erp-table">
                    <thead>
                    <tr>
                        <th><?php echo e(__('Date')); ?></th>
                        <th><?php echo e(__('Bill No')); ?></th>
                        <th><?php echo e(__('Received Amount')); ?></th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr>
                        <td><?php echo e(formatted_date($voucher->date)); ?></td>
                        <td><?php echo e($voucher->bill_no); ?></td>
                        <td class="fw-bold"><?php echo e(currency_format($voucher->amount ?? 0)); ?></td>
                    </tr>
                    </tbody>
                </table>
                <h5><b><?php echo e(__('Amount in word')); ?>: </b><?php echo e(ucfirst(amountInWords($voucher->amount) . ' dollar')); ?>.</h5>
                <div class="signature">
                    <p><?php echo e(__('Client Signature')); ?></p>
                    <p><?php echo e(__('Authorized Signature')); ?></p>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.blank', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/uliubxaw/wireprod/resources/views/pages/invoice/voucher.blade.php ENDPATH**/ ?>