<?php $__currentLoopData = $expenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $expense): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <tr>
        <td><?php echo e($loop->iteration); ?></td>
        <td><?php echo e(formatted_date($expense->created_at)); ?></td>
        <td><?php echo e($expense->party->name ?? ''); ?></td>
        <td><?php echo e($expense->party->type ?? ''); ?></td>
        <td><?php echo e($expense->category_name); ?></td>
        <td><b><?php echo e(currency_format($expense->total_bill)); ?></b></td>
        <td><b><?php echo e(currency_format($expense->total_paid)); ?></b></td>
        <td><b><?php echo e(currency_format($expense->total_due)); ?></b></td>
        <td>
            <div class="badge bg-<?php echo e($expense->status == 1 ? 'primary' : 'danger'); ?>">
                <?php echo e($expense->status == 1 ? 'Active' : 'Inactive'); ?>

            </div>
        </td>
        <td class="print-d-none">
            <div class="dropdown table-action">
                <button type="button" data-bs-toggle="dropdown">
                    <i class="far fa-ellipsis-v"></i>
                </button>
                <ul class="dropdown-menu">
                    <li>
                        <a href="<?php echo e(route('partial-payment.voucher', ['expense_id' => $expense->id])); ?>" target="_blank"><i class="fas fa-print"></i>
                            <?php echo e(__('Partial Payment')); ?>

                        </a>
                    </li>
                </ul>
            </div>
        </td>
    </tr>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php /**PATH /home/uliubxaw/wireprod/resources/views/pages/report/payable-dues/datas.blade.php ENDPATH**/ ?>