

<?php $__env->startSection('title'); ?>
    <?php echo e(__('Company Settings')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('main_content'); ?>
    <div class="erp-table-section">
        <div class="container-fluid">
            <div class="card shadow-sm">
                <div class="card-body">
                    <div class="table-header">
                        <h4><?php echo e(__('Company Settings')); ?></h4>
                    </div>
                    <div class="order-form-section">
                        <form action="<?php echo e(route('settings.update', $company->id)); ?>" method="post" enctype="multipart/form-data" class="ajaxform_instant_reload">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('put'); ?>
                            <div class="add-suplier-modal-wrapper d-block">
                                <div class="row">
                                    <div class="col-lg-12 mt-2">
                                        <label><?php echo e(__('Company Name')); ?></label>
                                        <input type="text" name="name" value="<?php echo e($company->value['name'] ?? ''); ?>"  required class="form-control" placeholder="Company Name">
                                    </div>
                                    <div class="col-lg-6 mt-2">
                                        <label><?php echo e(__('Company Email')); ?></label>
                                        <input type="text" name="email" value="<?php echo e($company->value['email'] ?? ''); ?>"  required class="form-control" placeholder="Company Name">
                                    </div>
                                    <div class="col-lg-6 mt-2">
                                        <label><?php echo e(__('Remarks')); ?></label>
                                        <input type="text" name="remarks" value="<?php echo e($company->value['remarks'] ?? ''); ?>"  required class="form-control" placeholder="Remarks">
                                    </div>
                                    <div class="col-lg-6 mt-2">
                                        <label><?php echo e(__('Address')); ?></label>
                                        <input type="text" name="address" value="<?php echo e($company->value['address'] ?? ''); ?>"  required class="form-control" placeholder="Address">
                                    </div>
                                    <div class="col-lg-6 mt-2">
                                        <label><?php echo e(__('Website')); ?></label>
                                        <input type="text" name="website" value="<?php echo e($company->value['website'] ?? ''); ?>" required  class="form-control" placeholder="Website Link">
                                    </div>

                                    <div class="col-lg-6 settings-image-upload">
                                        <label class="title"><?php echo e(__('Logo')); ?></label>
                                        <div class="upload-img-v2">
                                            <label class="upload-v4 settings-upload-v4">
                                                <div class="img-wrp">
                                                    <img src="<?php echo e(asset($company->value['logo'] ?? '')); ?>" alt="logo" id="logo" class="bg-secondary">
                                                </div>
                                                <input type="file" name="logo" class="d-none file-input-change" data-id="logo" accept="image/*">
                                            </label>
                                        </div>
                                    </div>
                                    <div class="col-lg-6 settings-image-upload">
                                        <label class="title"><?php echo e(__('Favicon')); ?></label>
                                        <div class="upload-img-v2">
                                            <label class="upload-v4 settings-upload-v4">
                                                <div class="img-wrp">
                                                    <img src="<?php echo e(asset($company->value['favicon'] ?? '')); ?>" alt="user" id="favicon">
                                                </div>
                                                <input type="file" name="favicon" class="d-none file-input-change" data-id="favicon" accept="image/*">
                                            </label>
                                        </div>
                                    </div>

                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('settings-update')): ?>
                                    <div class="col-lg-12">
                                        <div class="text-center mt-5">
                                            <button type="submit" class="theme-btn m-2 submit-btn"><?php echo e(__('Update')); ?></button>
                                        </div>
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/uliubxaw/wireprod/resources/views/pages/setting/company.blade.php ENDPATH**/ ?>