<?php $__currentLoopData = $parties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $party): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<tr class="odd">
    <td><?php echo e($loop->index+1); ?></td>
    <td><a href="#" class="text-primary"><?php echo e($party->name); ?></a></td>
    <td><?php echo e($party->phone); ?></td>
    <td>
        <b><?php echo e(currency_format($party->total_bill)); ?></b>
    </td>
    <td>
        <p><b class="text-success"><?php echo e(currency_format($party->advance_amount)); ?></b></p>
    </td>
    <td>
        <b><?php echo e(currency_format($party->pay_amount)); ?></b>
    </td>
    <td>
        <b><?php echo e(currency_format($party->due_amount)); ?></b>
    </td>
    <td><?php echo e($party->remarks); ?></td>
    <td class="print-d-none">
        <div class="dropdown table-action">
            <button type="button" data-bs-toggle="dropdown" aria-expanded="false" class="">
                <i class="far fa-ellipsis-v"></i>
            </button>
            <ul class="dropdown-menu">
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('transactions-read')): ?>
                    <li>
                        <a target="_blank" href="<?php echo e(route('party-ledger.show', $party->id)); ?>">
                            <i class="fal fa-eye"></i>
                            <?php echo e(__('Ledger')); ?>

                        </a>
                    </li>
                <?php endif; ?>
                <?php if(in_array(request('type'), ['buyer', 'customer'])): ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['credit-vouchers-read'])): ?>
                <li>
                    <a href="#due-collection" class="payment-received" data-id="<?php echo e($party->id); ?>" data-name="<?php echo e($party->name); ?>" data-url="<?php echo e(route('get-invoices', $party->id)); ?>" data-bs-toggle="modal">
                        <i class="fab fa-amazon-pay"></i>
                        <?php echo e(__('Pay Now')); ?>

                    </a>
                </li>
                <?php endif; ?>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('parties-update')): ?>
                    <li>
                        <a href="<?php echo e(route('parties.edit', $party->id)); ?>">
                            <i class="fal fa-pencil-alt"></i>
                            <?php echo e(__('Edit')); ?>

                        </a>
                    </li>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('parties-delete')): ?>
                    <li>
                        <a href="<?php echo e(route('parties.destroy', $party->id)); ?>" class="confirm-action" data-method="DELETE">
                            <i class="fal fa-trash-alt"></i>
                            <?php echo e(__('Delete')); ?>

                        </a>
                    </li>
                <?php endif; ?>
            </ul>
        </div>
    </td>
</tr>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

<?php $__env->startPush('modal'); ?>
<div class="modal fade" id="due-collection">
<div class="modal-dialog modal-dialog-centered modal-xl">
    <div class="modal-content">
        <div class="modal-header">
            <h1 class="modal-title fs-5"><?php echo e(__('Payment Received From')); ?> (<b class="party-name"></b>)</h1>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body order-form-section">
            <form action="<?php echo e(route('due-collections.store')); ?>" method="post" class="ajaxform transfer-create-form">
                <?php echo csrf_field(); ?>
                <div class="add-suplier-modal-wrapper">
                    <div class="row">
                        <div class="col-sm-6 col-lg-4 mt-2">
                            <label><?php echo e(__('Date')); ?></label>
                            <input type="hidden" name="party_id" class="party_id">
                            <input type="date" name="date" value="<?php echo e(now()->format('Y-m-d')); ?>"  class="form-control datepicker date" placeholder="Adjustment Date" required>
                        </div>
                        <div class="col-sm-6 col-lg-4 mt-2">
                            <label><span class="invoice_label">Select Invoice</span></label>
                            <div class="input-group">
                                <select name="income_id" class="form-control invoice income_id remove-bg-select">
                                    <option value=""><?php echo e(__('Select')); ?></option>
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-6 col-lg-4 mt-2">
                            <label><?php echo e(__('Payment method')); ?></label>
                            <div class="input-group">
                                <select name="payment_method" class="form-control table-select debit_payment_method" required>
                                    <option value=""><?php echo e(__('Select')); ?></option>
                                    <option value="bank"><?php echo e(__('Bank')); ?></option>
                                    <option value="cash"><?php echo e(__('Cash')); ?></option>
                                    <option value="cheque"><?php echo e(__('Cheque')); ?></option>
                                    <option value="party_balance"><?php echo e(__('Wallet')); ?></option>
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-6 col-lg-4 mt-2 cheque_input d-none">
                            <label><?php echo e(__('Cheque No')); ?></label>
                            <input type="number" name="cheque_no" class="form-control" placeholder="0202982883" required>
                        </div>
                        <div class="col-sm-6 col-lg-4 mt-2 cheque_input d-none">
                            <label>Issue Date</label>
                            <input type="date" name="issue_date" value="<?php echo e(now()->format('Y-m-d')); ?>"  class="form-control datepicker date" required>
                        </div>
                        <div class="col-sm-6 col-lg-4 mt-2 bank_cheque_input d-none">
                            <label><?php echo e(__('Select Bank')); ?></label>
                            <select name="bank_id" class="form-control w-100" required>
                                <option value="">-<?php echo e(__('Select Bank')); ?>-</option>
                                <?php $__currentLoopData = $banks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($bank->id); ?>" ><?php echo e($bank->bank_name .' - '. $bank->account_number); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="col-sm-6 col-lg-4 mt-2">
                            <label><?php echo e(__('Due Amount')); ?></label>
                            <input type="number" name="amount" required class="form-control due-amount" readonly placeholder="$5000">
                        </div>
                        <div class="col-sm-6 col-lg-4 mt-2">
                            <label><?php echo e(__('Paying Amount')); ?></label>
                            <input type="number" name="amount" required class="form-control amount paying-amount" placeholder="$5000">
                        </div>
                        <div class="col-sm-6 col-lg-4 mt-2">
                            <label class="change-lable"><?php echo e(__('Change Return')); ?></label>
                            <input type="number" step="any" class="form-control change-amount" value="<?php echo e(currency_format(0)); ?>" readonly>
                        </div>

                        <div class="col-lg-12 mt-2">
                            <label><?php echo e(__('Note')); ?></label>
                            <textarea name="remarks" class="form-control"></textarea>
                        </div>
                        <div class="col-lg-12">
                            <div class="button-group text-center mt-5">
                                <button type="reset" class="theme-btn border-btn m-2"><?php echo e(__('Reset')); ?></button>
                                <button class="theme-btn m-2 submit-btn"><?php echo e(__('Save')); ?></button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
</div>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('js'); ?>
<script src="<?php echo e(asset('assets/js/custom/custom.js')); ?>"></script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/uliubxaw/wireprod/resources/views/pages/accounts/general/dues/datas.blade.php ENDPATH**/ ?>