<?php $__currentLoopData = $salaries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $salary): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <tr>
        <td><?php echo e($loop->iteration); ?></td>
        <td class="text-dark fw-bold"><?php echo e(optional($salary->employee)->name .' - '. optional($salary->employee)->phone); ?></td>
        <td><?php echo e($salary->month); ?></td>
        <td><?php echo e($salary->year); ?></td>
        <td class="text-dark fw-bold"><?php echo e(currency_format(optional($salary->employee)->salary)); ?></td>
        <td class="text-dark fw-bold"><?php echo e(currency_format($salary->amount)); ?></td>
        <td class="text-dark fw-bold"><?php echo e(currency_format($salary->due_salary)); ?></td>
        <td>
            <?php if($salary->payment_method == 'cash'): ?>
                Cash
            <?php elseif($salary->payment_method == 'bank'): ?>
                Bank
            <?php elseif($salary->payment_method == 'cheque'): ?>
                Cheque
            <?php endif; ?>
        </td>
        <td><?php echo e(formatted_date($salary->created_at)); ?></td>
        <td class="print-d-none">
            <div class="dropdown table-action">
                <button type="button" data-bs-toggle="dropdown">
                    <i class="far fa-ellipsis-v"></i>
                </button>
                <ul class="dropdown-menu">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('salaries-update')): ?>
                    <li>
                        <a href="<?php echo e(route('salaries.edit', $salary->id)); ?>" class="edit-btn">
                            <i class="fal fa-pencil-alt"></i>
                            <?php echo e(__('Edit')); ?>

                        </a>
                    </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('salaries-delete')): ?>
                    <li>
                        <a href="<?php echo e(route('salaries.destroy', $salary->id)); ?>" class="confirm-action" data-method="DELETE">
                            <i class="fal fa-trash-alt"></i>
                            <?php echo e(__('Delete')); ?>

                        </a>
                    </li>
                    <?php endif; ?>
                </ul>
            </div>
        </td>
    </tr>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php /**PATH /home/uliubxaw/wireprod/resources/views/pages/salaries/datas.blade.php ENDPATH**/ ?>